@php
    global $ulz_listing;
@endphp

@if( ! empty( $items ) )
    <div class="ulz-mod-listing ulz-mod-listing-bullets" data-type="bullets">
        @if( ! empty( $name ) )
            <h4>{{ $name }}</h4>
        @endif
        <div class="ulz-bullets ulz--{{ $style }} ulz--x{{ $num_columns }}">
            <{!! $style == 'table' ? 'table class="ulz-table ulz--reverse"' : 'ul' !!}>
                @if( $style == 'table' )
                    <tbody>
                @endif

                @foreach( $items as $item )

                    @php

                        $field_item = $ulz_listing->get_field_item( $item->fields->key );
                        $type = isset( $item->fields->type ) ? $item->fields->type : '';

                        // custom field
                        if( $field_item ) {

                            // multiple
                            if( $field_item->template->id == 'taxonomy' ) {
                                $meta_value = Ucore()->get( $item->fields->key, $ulz_listing->id, false );

                                $values = [];
                                if( is_array( $meta_value ) ) {
                                    foreach( $meta_value as $value ) {

                                        $term = get_term_by( 'id', $value, Ucore()->prefix( $field_item->fields->key ) );

                                        if( ! $term ) {
                                            continue;
                                        }

                                        $icon = [];
                                        if( $icon_data = get_term_meta( $term->term_id, 'ulz_icon', true ) && isset( $icon_data[0] ) ) {
                                            $icon = [
                                                'set' => $icon_data[0]->set,
                                                'icon' => $icon_data[0]->icon,
                                            ];
                                        }

                                        $values[] = (object) [
                                            'name' => $term->name,
                                            'icon' => $icon,
                                        ];

                                    }
                                }

                                $meta_value = $values;

                            }
                            // single
                            else{
                                $meta_value = $ulz_listing->get( $item->fields->key );
                            }

                            if( ! $meta_value ) {
                                continue;
                            }

                        }
                        // built-in field
                        else{
                            $meta_value = $ulz_listing->get( $item->fields->key );
                        }

                    @endphp

                    {{-- single --}}
                    @if( ! is_array( $meta_value ) )

                        @if( $meta_value )

                            @if( $style == 'table' )
                                <tr><td>{{ $item->fields->name }}</td>
                            @endif

                            <{{ $style == 'table' ? 'td' : 'li' }}>

                                @if( isset( $item->fields->icon[0] ) )
                                    {!! utillz_core()->icon->get( $item->fields->icon[0]->icon, $item->fields->icon[0]->set ) !!}
                                @endif

                                @switch( $type )

                                    @case('address')
                                        <a href="{{ add_query_arg( [ 'api' => 1, 'query' => urlencode( esc_html( $meta_value ) ) ], 'https://www.google.com/maps/search/' ) }}" target="_blank">
                                            {{ str_replace( '{field}', $meta_value, $item->fields->format ) }}
                                        </a>
                                        @break

                                    @case('url')
                                        <a href="{{ esc_url( str_replace( '{field}', $meta_value, $item->fields->format ) ) }}" target="_blank">
                                            @if( isset( $item->fields->type_url_label ) && ! empty( $item->fields->type_url_label ) )
                                                {{ $item->fields->type_url_label }}
                                            @else
                                                {{ str_replace( '{field}', $meta_value, $item->fields->format ) }}
                                            @endif
                                        </a>
                                        @break

                                    @case('phone')
                                        <a href="tel:{{ $meta_value }}" target="_blank">
                                            {{ str_replace( '{field}', $meta_value, $item->fields->format ) }}
                                        </a>
                                        @break

                                    @case('email')
                                        <a href="mailto:{{ $meta_value }}" target="_blank">
                                            {{ str_replace( '{field}', $meta_value, $item->fields->format ) }}
                                        </a>
                                        @break

                                    @case('price')
                                        <span>
                                            {!! str_replace( '{field}', Ucore()->format_price( $meta_value ), $item->fields->format ) !!}
                                        </span>
                                        @break

                                    @default

                                        <span>
                                            {{ str_replace( '{field}', $meta_value, $item->fields->format ) }}
                                        </span>

                                @endswitch

                            </{{ $style == 'table' ? 'td' : 'li' }}>

                            @if( $style == 'table' )
                                </tr>
                            @endif

                        @endif

                    {{-- multiple --}}
                    @else

                        @foreach( $meta_value as $value )
                            @if( ! is_object( $value ) )
                                @continue;
                            @endif
                            @if( $style == 'table' )
                                <tr><td>{{ $item->fields->name }}</td>
                            @endif
                            <{{ $style == 'table' ? 'td' : 'li' }}>
                                @if( $value->icon )
                                    {{ Ucore()->icon->get( $value->icon->icon, $value->icon->set ) }}
                                @endif
                                <span>
                                    {{ str_replace( '{field}', $value->name, $item->fields->format ) }}
                                </span>
                            </{{ $style == 'table' ? 'td' : 'li' }}>
                            @if( $style == 'table' )
                                </tr>
                            @endif
                        @endforeach

                    @endif

                @endforeach

                @if( $style == 'table' )
                    </tbody>
                @endif

            </{{ $style == 'table' ? 'table' : 'ul' }}>
        </div>
    </div>
@endif
